//below works for Uno/Mega
#define DATA_PIN 1
#define DATA_SERIAL Serial

/*
//use below for Leonardo
#define DATA_PIN 1
#define DATA_SERIAL Serial1

//Using other TX ports on Mega
//TX3
#define DATA_PIN 14
#define DATA_SERIAL Serial3

//TX2
#define DATA_PIN 16
#define DATA_SERIAL Serial2

//TX1
#define DATA_PIN 18
#define DATA_SERIAL Serial1

*/
byte b[64]={
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  
byte d[6]={85,170,255,170,85,0};

void setup() {
  //set idle state
  tone(3,50);                     //mains simulator
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
  sendFrame(b,4);
  
}

void loop() {
  int s,t,u;
  for(s=0;s<4;s++){
    for(t=0;t<6;t++){
      for(u=0;u<60;u=u+4){
        b[s+u]=d[t];
      }
      sendFrame(b,64);
      delay(100);
    }
  }
}

void sendFrame(char* d, int n){ //array d of size n
  int i;
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
  digitalWrite(DATA_PIN,LOW);     //idle high
  delayMicroseconds(572);         //22 bit times
  digitalWrite(DATA_PIN,HIGH);    //idle high
  DATA_SERIAL.begin(38400);
  DATA_SERIAL.write(0);           //data to follow
  for(i=0;i<n;i++){
    DATA_SERIAL.write(d[i]);
  }
  DATA_SERIAL.end();
  digitalWrite(DATA_PIN,HIGH);    //idle high
  pinMode(DATA_PIN,OUTPUT);       //set
}

